
# INSTALL

  

This file provides step-by-step instructions for installing and testing the software components included in the artifact:

**"Exploring Empathy in Software Engineering: Insights from a Grey Literature Analysis of Practitioners' Perspectives"**

  

---

  

## 1. Install Python (if not already installed)

  

We recommend Python 3.7 or later.

  

Check version:

```bash

python  --version

```

  

## 2. Set up a virtual environment (optional but recommended)

```bash

  

python  -m  venv  venv

source  venv/bin/activate  # On Windows: venv\Scripts\activate

```

  
  

## 3. Install dependencies

Install selenium using pip:

```bash

pip  install  -r  requirements.txt

```

  

## 4. Download and configure ChromeDriver

Visit: https://sites.google.com/chromium.org/driver/

  

Download the version matching your installed Google Chrome.

Extract the executable and ensure it’s in your system’s PATH.

  

## 5. Run the scraper

Navigate to the GL_Study/ directory and run:

```bash

python  dev_scraper.py

```

  

**Expected output:**

  

A CSV file named dev_articles.csv (or similar) containing titles and URLs of DEV.to articles tagged with "empathy".

  

## 6. (Optional) Use Google Sheets script

- Use the IMPORTJSON.gs script inside Google Sheets:

 - Download the script: https://github.com/bradjasper/ImportJSON/

- Open a new Google Sheet.

  

- Go to Extensions > Apps Script and paste the content of IMPORTJSON.gs.

  

- Use the formula:

```bash

=ImportJSON("https://dev.to/api/articles?tag=empathy;per_page=1000")

```

  

## 8. Troubleshooting

If you encounter WebDriver issues, ensure:

  

- ChromeDriver matches your Chrome browser version

  

- ChromeDriver binary is executable and in your PATH

  

## Contact

For installation issues, contact:

  

Lidiany Cerqueira – lidiany.cerqueira@ufba.br

Federal University of Bahia (UFBA)